/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.pa.problem;

import com.ibm.hwmca.base.pa.ar.XMLHelper;
import com.ibm.hwmca.base.util.BaseFileControl;
import com.ibm.hwmca.fw.pa.ProblemAnalysisManager;
import com.ibm.hwmca.fw.pa.fedc.FEDCJavaExecutable;
import com.ibm.hwmca.fw.pa.problem.Problem;
import com.ibm.hwmca.fw.pa.problem.ProblemManager;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.xfw.pa.problem.CommonProblem;
import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class GetProblemData
implements Runnable,
FEDCJavaExecutable {
    private static final String TRACE_MASKT = "XPAGETPT";
    private static final String TRACE_MASKF = "XPAGETPF";
    private static final String TRACE_MASKD = "XPAGETPD";
    private static final int _maxNumberOfProblems = 5;
    private String _parms = null;
    private Problem _problem;

    public GetProblemData(String parms) {
        Trace.trace(TRACE_MASKT, "--> GetProblemData.ctor (" + parms + ")");
        this._parms = parms;
        Trace.trace(TRACE_MASKT, "<-- GetProblemData.ctor (" + parms + ")");
    }

    public Problem getProblem() {
        Trace.trace(TRACE_MASKT, "<--> getProblem ");
        return this._problem;
    }

    public void setProblem(Problem problem) {
        Trace.trace(TRACE_MASKT, "--> setProblem ");
        this._problem = problem;
        Trace.trace(TRACE_MASKD, "the problem is " + problem.getUniqueKey());
        Trace.trace(TRACE_MASKT, "<-- setProblem ");
    }

    public void run() {
        ProblemManager pm = null;
        Trace.trace(TRACE_MASKD, "running GetProblemData");
        if (this._problem != null) {
            Trace.trace(TRACE_MASKD, "running for problem " + this._problem.getUniqueKey());
        } else {
            Trace.trace(TRACE_MASKD, "the problem wasn't set");
        }
        try {
            pm = ProblemManager.getProblemManager();
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "got an exception");
            Trace.trace(TRACE_MASKF, e);
        }
        if (pm != null) {
            List problemList = pm.getAllProblems();
            List shortList = this.shortenList(problemList, this._problem.getProblemNumber());
            int currentProblemNumber = this._problem.getProblemNumber();
            if (currentProblemNumber > 0) {
                Trace.trace(TRACE_MASKD, "shortList.size() " + shortList.size());
                ListIterator problemIt = shortList.listIterator();
                StringBuffer sb = new StringBuffer(2000);
                sb.append("<problems>");
                Problem element = null;
                int j = 0;
                while (problemIt.hasNext()) {
                    Trace.trace(TRACE_MASKD, "j =" + j);
                    element = (Problem)problemIt.next();
                    XMLHelper.outToXML(element, sb, element.getClass());
                    ++j;
                }
                sb.append("</problems>");
                Trace.trace(TRACE_MASKD, "done with making the problem data");
                try {
                    String path = BaseFileControl.getFilePath("paproblemdata");
                    File file = new File(path);
                    file.mkdir();
                    FileWriter fw = new FileWriter(path + "problems.xml");
                    fw.write(sb.toString());
                    fw.close();
                    Trace.trace(TRACE_MASKD, "wrote the file");
                }
                catch (Exception e) {
                    Trace.trace(TRACE_MASKD, "exception");
                    Trace.trace(TRACE_MASKD, e);
                }
            }
        }
    }

    public static void main(String[] args) {
        GetProblemData me = new GetProblemData("test");
        try {
            Trace.trace(TRACE_MASKD, "start up the problem manager");
            Thread myThread = new Thread(new ProblemAnalysisManager.Init());
            myThread.start();
            Thread.sleep(5000L);
            Trace.trace(TRACE_MASKD, "done starting the manager");
            CommonProblem newProblem = new CommonProblem();
            ProblemManager pm = ProblemManager.getProblemManager();
            pm.open(newProblem);
            me.setProblem(newProblem);
            me.run();
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKD, "got an exception");
            Trace.trace(TRACE_MASKD, e);
        }
    }

    protected List shortenList(List longList, int currentProblemNumber) {
        ArrayList<Problem> shortList = new ArrayList<Problem>(5);
        Iterator longListIt = longList.iterator();
        int count = 0;
        while (longListIt.hasNext() && count < 5) {
            Problem workingProblem = (Problem)longListIt.next();
            int workingProblemNumber = workingProblem.getProblemNumber();
            if (workingProblemNumber <= currentProblemNumber - 5) continue;
            Trace.trace(TRACE_MASKD, "add problem " + workingProblemNumber + " to the short list");
            shortList.add(workingProblem);
            ++count;
        }
        Trace.trace(TRACE_MASKF, "short list is " + shortList.size());
        return shortList;
    }
}

